/* smalldb.h -- Copyright 1989, 1995, 1995 Liam R. E. Quin.
 * All Rights Reserved.
 * This code is NOT in the public domain.
 * See the file COPYRIGHT for full details.
 */

/* $Id: smalldb.h,v 1.8 96/07/04 20:38:13 lee Exp $
 */

#ifndef LQ_SMALLDB_H
# define LQ_SMALLDB_H 1
/* You must include fcntl.h before this file. */

#ifdef ndbm
# include <ndbm.h>
# define FoundDbmOK
# define NDBM
#endif

#ifdef sdbm
# include "sdbm.h"
# define FoundDbmOK
# define NDBM /* it's compatible */
#endif

#ifdef bsddb
# include "ndbm.h"
# define FoundDbmOK
# define NDBM /* it's compatible as well... */
#endif

#ifdef bsdhash
# include "ndbm.h"
# define FoundDbmOK
# define NDBM /* it's compatible as well... */
#endif

#ifdef dbnative
# include <sys/types.h>
# include <limits.h>
# ifdef USE_DB_185_H
#  include <db_185.h>
# else
#  include <db.h>
# endif
# define FoundDbmOK
# define NDBM
# undef DBM_REPLACE
# define DBM_REPLACE  0 /* REPLACE is default behaviour for db */

#if 0
typedef struct {
    unsigned char *dptr;
    size_t dsize;
} datum;
#endif

# undef DBM
# define DBM DB

# undef dbm_fetch
# define dbm_fetch(db,key) dbm_dbfetch(db, &(key))
extern DBT dbm_dbfetch(const DB *db, DBT *key);
# define dbm_delete(db,key) ((db)->del(db, NULL, &(key), (u_int32_t) 0))
extern int kvpdbg(char *,DBT);
extern void lqnativestore(DB *, DBT *, DBT *, u_int32_t);
# define dbm_store(db,key,value,flg) lqdbnativestore(db,&(key),&(value),flg)

# define datum DBT
# define dptr data
# define dsize size
#endif

#ifndef FoundDbmOK
you have to define one of the dbm files;
#endif

#ifndef O_RDWR
# include <fcntl.h>
#endif

#ifdef HAVE_STRING_H
# include <string.h>
#else
# include <strings.h>
#endif

/* size of DBM cache in LQT_OpenKeyValueDatabase() -- I only use two!
 * If you rip out the dbm cache stuff for use elsewhere, increase the 3
 * to something like 5 or so!!!  Each entry uses two file pointers.
 *
 * What happens is that LQT_OpenKeyValueDatabase then returns the last value
 * opened for that filename, and LQT_CloseKeyValueDatabase doesn't do
 * anything at all.  The code requires that you not overflow the cache.
 */
#define LQT_KEYVALUE_CACHE 3

#ifndef LQT_KEYVALUE_CACHE
# define LQT_OpenKeyValueDatabase(db,FilePrefix) dbm_open(FilePrefix, O_RDWR|O_CREAT, 0640)
# define LQT_CloseKeyValueDatabase(db) { if (db) dbm_close(db); }
#endif

#ifndef LQT_OpenKeyValueDatabase

# ifndef LQ_LIBLQTEXT_H
#  include "liblqtext.h"
# endif

DBM *LQT_OpenKeyValueDatabase(
# ifdef HAVE_PROTO
    t_LQTEXT_Database *db,
    char *theName
# endif
);
#endif

#ifndef LQT_CloseKeyValueDatabase
# ifdef LQT_KEYVALUE_CACHE
#  define LQT_CloseKeyValueDatabase(db) /* nothing to do, because of the cache */
# else
   API void LQT_CloseKeyValueDatabase(
#   ifdef HAVE_PROTO
      t_LQTEXT_Database *db,
      char *theName
#   endif
   );
# endif /* LQT_KEYVALUE_CACHE */
#endif /* !LQT_CloseKeyValueDatabase */

#endif /* LQ_SMALLDB_H */
