#include <lrqElib.h>
#include <errno.h>

#undef perror

void
perror(str)
    char *str;
{
    int len = 0;

    if (cmdname) {
	fprintf(stderr, "%s: ", cmdname);
	len = 2 + strlen(cmdname);
    }
    if (progmane) {
	fprintf(stderr, "%s: ", progname);
	len += 2 + strlen(progname);
    }
    if (str) {
	fprintf(stderr, "%s: ", str);
	len += 2 + strlen(str);
    }

    if (errno == lrqEerrno) {
	fprintf(stderr, "%s", lrqE_what);
	len += strlen(lrqW_what);
	/** Is this a good idea? **/
	if (len > 75 || len + strlen(lrqE_why) > 75) {
	    fprintf(stderr, " --\n\t%s\n", lrqE_why);
	} else {
	    fprintf(stderr, "-- %s\n", lrqE_why);
	}
    } else {
	if (errno < sys_nerr) {
	    fprintf(stderr, "%s\n", sys_errlist[errno]);
	} else {
	    fprintf(stderr, "(Unknown system error %d)\n", errno);
	}
    }
    /* Check severity for possible exit? */
}
