
/* Things that can call errors */
#define lrqE_ESYS  1 /* a "system call" */
#define lrqE_ELIB  2 /* a standard library function */
#define lrqE_EULIB 3 /* a user-defined library function */
#define lrqE_EAPPL 4 /* A user's application program */
#define lrqE_EAUTO 5 /* an automatically generated program */

/** Arguments you can give to lrqE_error() **/
/* (assumes you've not used seterror(), of course) */

/* The default; only messages with severity > ENORMAL are printed  */
#define lrqE_ENORMAL 100 /* Must be > E_MASK of course! */
extern int lrqE_severity;

/* Urgent messages are printed even if errors are otherwise disabled;
 * all program errors are considered "urgent" in this sense.
 */
#define lrqE_EURGENT	500

/* programming error -- e.g. read(0, 0, 1) -- you get the message
 * "program error"
 * at the start
 */
#define lrqE_EPROG	(lrqE_EURGENT|lrqE_EINTERNAL)

/* Error types, OR'd in with the severity */
#define lrqE_E_MASK	017 /* 4 bits available for erorr types */
#define lrqE_EFATAL	01 /* odd numbers are always fatal */
#define lrqE_EWARN	02
#define lrqE_EINTERNAL	03
#define lrqE_EINFO	04


/** Functions and system calls **/
#ifdef lrqE
# define fopen	lrqEfopen
# define open	lrqEopen
# define fclose	lrqEfclose
# define close	lrqEclose
# define malloc	lrqEmalloc
# define calloc	lrqEcalloc
# define realloc	lrqErealloc
# define read	lrqEread
# define unlink lrqEunlink
# define write	lrqEwrite
#endif

# define lrqE_error (* lrqE_eprfunc)

extern void lrqE_noerror();
extern void lrqE_error(); /* print an error message and maybe exit */
typedef void (* lrqE__vfp)();
extern lrqE__vfp lrqE_seterror(); /* returns the previous value */
