#include "lrqElib.h"
#include "lrqEdefs.h"
#include <fcntl.h>
#include <errno.h>
#include <sys/types.h>
#include <sys/stat.h>

/* let's get the real versions */
#undef open
#undef stat
#undef malloc
#include <malloc.h>

/* You should only call this function if you got an error from a
 * system call which left errno as ENOTDIR
 */

char *
lrqEcheckpath(path, mode)
    char *path;
    char *mode;
{
    /* First see if all of the elements in the path are directories.
     */
    char *p;
    int n_tried = 0;
    struct stat parent;
    char *pp = 0; /* parent pointer */

    for (p = path; *p; p++) {
	if (*p == '/' && p > path) {
	    char *boy;
	    char *lrqE_perms();
	    n_tried++;
	    *p = '\0';
	    pp = p; /* in case this was the parent directory */

	    if (!lrqE_isdir(path)) {
		char *q = malloc(strlen(path) + 23); /* see *** below */
		register char *bp;

		if (p == (char *) 0) {
		    *p = '/';	/* restore the damage... */
		    return "a component of the path isn't a directory";
		}

		/* p now points just beyond the end of the offending path */
		for (bp = p; bp > path; --bp) {
		    if (*bp == '/') {
			if (++bp < p) /* in case of "/bin//ls" */
			    break;
			else bp--;
		    }
		}
		/* *** the 23 above is for this: */
		sprintf(q, "\"%s\" isn't a directory.", path);
		*p = '/';	/* restore the damage... */
		return q;
	    } else if ((boy = lrqE_perms(path, mode)) != (char *) 0) {
		/* Check permissions */
		char *q = malloc(strlen(boy) - 1 + strlen(path));
		/* -2 for %s + 1 for \0 */

		(void) sprintf(q, boy, path);
		return q;
	    }

	    /* restore the damage... */
	    *p = '/';
	} /* end if */
    } /* end for */

    /* Hmph.  Now check the parent directory */
    if (!n_tried) {
	if (stat("..", &parent) < 0) {
	    return "there isn't a parent directory (..)";
	} 
    } else {
	*pp = '\0';
	if (stat(path, &parent) < 0) { /* maybe someone did an rm -r */
	    *p = '/';
	    return "the directory containing it just vanished!";
	}
    }
    return "a component of the path might not be a directory";
}

int
lrqE_isdir(path)
    char *path;
{
    struct stat s;

    if (stat(path, &s) < 0) {
	return -1;
    }
    return (s.st_mode & S_IFDIR) ? 1 : 0;
}

char *
lrqE_perms(path, mode)
    char *path;
    char *mode;
{
    int m;

    if (path == (char *) 0) {
	return "[corrupt pathname]";
    }
    if (access(path, 01) < 0) {
	return "no permission to search directory %s";
    }
    if (access(path, 04) < 0) {
	return "can't read directory %s";
    }
    return (char *) 0;
}
