#include "lrqElib.h"
#include "lrqEdefs.h"
#include <fcntl.h>
#include <malloc.h>

#ifdef lrqEmalloc
# undef lrqEmalloc
#endif
#undef malloc

char *
lrqEmalloc(size)
    unsigned int size;
{
    char *retval;
    extern char *malloc(); /* yes, this IS needed! */
    int ewhat; /* error type */

    /* ASSERT: size >= 0 (because it's unsigned!) */

#if 0
    /* Try to avert a core dump... */
    if (size < 4) {
	size = 4;
    }
#endif

    if ((retval = malloc(size)) != (char *) 0) {
	return retval;
    }
    /* we have an error */

    ewhat = lrqE_EPROG;
    lrqE_error(ewhat, "request for %u more bytes refused", size);
    /*NOTREACHED*/
    return (char *) 0;
}

#ifdef lrqErealloc
# undef lrqErealloc
#endif
#undef realloc

char *
lrqErealloc(ptr, size)
    unsigned int size;
    char *ptr;
{
    char *retval;
    int savsyserrno;
    extern char *realloc(); /* yes, this IS needed! */

    if (!ptr) {
	lrqE_error(lrqE_EPROG, "program must't realloc null pointer");
    }

    /* ASSERT: size >= 0 (because it's unsigned!) */

    /* Try to avert a core dump... */
    if (size < 4) {
	size = 4;
    }

    if ((retval = realloc(ptr, size)) != (char *) 0) {
	return retval;
    }
    /* we have an error */

    lrqE_error(lrqE_EFATAL, "request for %u more bytes refused; program error", size);
    /*NOTREACHED*/
    return (char *) 0;
}

#ifdef lrqEcalloc
# undef lrqEcalloc
#endif
#undef calloc

char *
lrqEcalloc(nelem, size)
    unsigned int size;
    unsigned int nelem;
{
    char *retval;
    int savsyserrno;
    extern char *calloc(); /* yes, this IS needed! */

    /* ASSERT: size >= 0 (because it's unsigned!) */

    /* Try to avert a core dump... */
    if (size < 4) {
	size = 4;
    }

    if ((retval = calloc(nelem, size)) != (char *) 0) {
	return retval;
    }
    /* we have an error */

    lrqE_error(lrqE_EPROG, "request for %u more bytes refused", size);
    /*NOTREACHED*/
    return (char *) 0;
}
