#include "lrqElib.h"
#include "lrqEdefs.h"
#include <fcntl.h>
#include <errno.h>
#include <sys/types.h>
#include <sys/stat.h>

#ifdef lrqEopen
# undef lrqEopen
#endif
#undef open

extern char lrqEwhat[];
extern char lrqEwhy[];

int
lrqEopen(path, whatfor, creatmode)
    char *path;
    int whatfor;
    int creatmode;
{
    int fd;
    int savsyserrno;
    char *otext, *mtext, *special;
    int ewhat;
    int writing = 0;
    char *what = "file"; /* file/fifo/device/directory */
    char *why;

    errno = 0;

    if ((fd = open(path, whatfor, creatmode)) >= 0) {
	return fd;
    }

    /* ASSERT: we have an error */

    /* Save the original error number */
    savsyserrno = errno;


    if (path == (char *) 0) {
	why = "open() called with null argument";
	lrq__setwhat(what);
goto solved2;
    } else if (errno == EFAULT) {
	path = "[corrupted path]"; /* so we don't derefernce garbage! */
	why = "open() called with corrupt pointer";
	lrq__setwhat(what);
goto solved2;
    }

    /**
     * Build up a message:
     * can't %s \"%s\" for %s %s because %s
     * |..... what ............|	 |why...|
     * otext file mtext special why
     */

    /* Make a description of what we tried to do.. */
    if (whatfor & O_CREAT) {
	otext = "create";
    } else {
	if (whatfor & O_TRUNC) {
	    otext = "open (truncate)";
	} else {
	    otext = "open";
	}
    }
    if (whatfor & O_RDWR) {
	mtext = "update";
	writing = 1;
    } else if (whatfor & O_WRONLY) {
	mtext = "writing";
	writing = 1;
    } else {
	mtext = "reading";
    }

    if (whatfor & O_EXCL) {
	special = "(for exclusive access) -- \n\t";
    } else {
	special = "-- ";
    }

    /** Try to figure out the problem... **/

    /* Some special cases: */
    switch (savsyserrno) {
    case EAGAIN:
	why = "it already exists, and there are outstanding locks (EAGAIN)";
	ewhat = lrqE_EFATAL;
	break;
    case EEXIST:
	why = "it already exists";
	ewhat = lrqE_EFATAL;
	break;
    case EFAULT:
	why = "the path was corrupt [EFAULT]";
	ewhat = lrqE_EFATAL;
	break;
    case EINTR:
	/* See if we can do it again this time! */
	if ((fd = open(path, whatfor, creatmode)) >= 0) {
	    return fd;
	}
	why = "a signal interrupted the system call.";
	ewhat = lrqE_EFATAL;
	break;
    case EIO:
	why = "there was a hangup or STREAMS error";
	ewhat = lrqE_EFATAL;
	break;
    case EISDIR:
	why = "can't alter directories";
	ewhat = lrqE_EFATAL;
	what = "directory";
	break;
    case EMFILE:
	why = "too many files are already open";
	ewhat = lrqE_EFATAL;
	break;
    case EMULTIHOP:
	why = "MULTIHOP bug in RFS; use NFS instead!";
	ewhat = lrqE_EFATAL;
	what = "remote file";
	break;
    case ENFILE:
	why = "the system file table is full";
	ewhat = lrqE_EFATAL;
	break;
    case ENOLINK:
	why = "the remote machine it's is now unavailable";
	ewhat = lrqE_EFATAL;
	what = "remote file";
	break;
    case ENOMEM:
	why = "the system has run out of memory [ENOMEM]";
	ewhat = lrqE_EFATAL;
	break;
    case ENOSPC:
	why = "the file system has run out of i-nodes";
	ewhat = lrqE_EFATAL;
	break;
    case ENOSR:
	why = "no streams are available";
	ewhat = lrqE_EFATAL;
	what = "streams device";
	break;
    case ENOENT:
	/*NOTDONE: which */
	if (whatfor & O_CREAT) {
	    why = "a directory in the path doesn't exist";
	} else {
	    why = "it doesn't exist";
	}
	ewhat = lrqE_EFATAL;
	break;
    case ENOTDIR:
	/*NOTDONE: find out which! */
	{
	    extern char *lrqEcheckpath();

	    char *d = lrqEcheckpath(path, "d");
	    if (d != (char *) 0) {
		why = d;
	    } else {
		why = "one of the path compnents isn't a directory.";
	    }
	    ewhat = lrqE_EFATAL;
	}
	break;
    case ENXIO:
	what = "special device";
	ewhat = lrqE_EFATAL;
	why = "no kernel driver, or polluted stream [ENXIO]";
	break;
    case EROFS:
	why = "the file system is mounted read-only";
	ewhat = lrqE_EFATAL;
	break;
    case ETXTBSY:
	what = "program text";
	why = "the program is currently running";
	ewhat = lrqE_EFATAL;
	break;
    default:
	if (savsyserrno < sys_nerr) {
	    why = sys_errlist[savsyserrno];
	} else {
	    why = lrqEwhy;
	    (void) sprintf(why, "unknown error %d -- see intro(2)",
		savsyserrno);
	}
	ewhat = lrqE_EFATAL|lrqE_EINTERNAL;
	break;
    }

solved:
    lrq__setwhat("can't %s %s \"%%s\" for %s %s", otext, what, mtext, special);
solved2:
    if (why != lrqEwhy) lrq__setwhy(why);

    /* Restore errno */
    errno = savsyserrno;

    lrqE_error(ewhat, "open", path, lrqEwhat, lrqEwhy);
}
