#include "lrqElib.h"
#include "lrqEdefs.h"
#include <fcntl.h>
#include <errno.h>
#include <sys/types.h>
#include <sys/stat.h>

#ifdef lrqEunlink
# undef lrqEunlink
#endif
#undef unlink

extern char lrqEwhat[]; /* for the "why" */
extern char lrqEwhy[]; /* for the "why" */

int
lrqEunlink(path)
    char *path;
{
    int savsyserrno;
    int ewhat;
    char *object = "file"; /* file/fifo/device/directory */
    char *what = "internal error";
    char *why;

    errno = 0;

    if (unlink(path) == 0) {
	return 0;
    }
    /* we have an error */

    /* Save the original error message */
    savsyserrno = errno;

    if (path == (char *) 0) {
	why = "unlink() called with null argument";
	lrq__setwhat(what);
goto solved2;
    } else if (errno == EFAULT) {
	path = "[corrupted path]"; /* so we don't derefernce garbage! */
	why = "unlink() called with corrupt pointer";
	lrq__setwhat(what);
goto solved2;
    }

    /**
     * can't unlink %s "%s\" for %s %s because %s
     * 		   what path mtext special reason
     */

    /** Try to figure out the problem... **/

    /* Some special cases: */
    switch (savsyserrno) {
    case EINTR:
	why = "a signal interrupted the system call.";
	break;
    case EMULTIHOP:
	why = "MULTIHOP bug in RFS; use NFS instead!";
	what = "remote file";
	break;
    case ENOENT:
	why = "it doesn't exist";
	break;
    case ENOLINK:
	why = "the remote machine it's on is now unavailable";
	what = "remote file";
	break;
    case EACCES: /* sic */
    case ENOTDIR:
	/* find out which! */
	{
	    extern char *lrqEcheckpath();

	    char *d = lrqEcheckpath(path, "d");
	    if (d != (char *) 0) {
		why = d;
	    } else {
		if (savsyserrno == ENOTDIR) {
		    why = "one of the path compnents isn't a directory";
		} else {
		    why = "permission denied somewhere";
		}
	    }
	}
	break;
    case EROFS:
	why = "the file system it's on is mounted read-only";
	break;
    case ETXTBSY:
	what = "program text";
	why = "the program is currently running";
	ewhat = lrqE_EFATAL;
	break;
    case EBUSY:
	why = "there is a file system mounted on it";
	break;
    case EPERM:
	why = "only the superuser can remove directories";
	break;
    default:
	/* Parent could have sticky bit, but undefined errno then */
	if (savsyserrno < sys_nerr) {
	    why = sys_errlist[savsyserrno];
	} else {
	    (void) sprintf(lrqEwhy, "unknown error %d -- see intro(2)",
		savsyserrno);
	}
	ewhat = lrqE_EFATAL|lrqE_EINTERNAL;
	break;
    }

solved:
    /* unlink: can't remove directory "%s": permission denied
     */
    lrq__setwhat("can't remove %s \"%%s\"", what);
solved2:
    if (why != lrqEwhy) lrq__setwhy(why);

    /* Restore errno */
    errno = savsyserrno;

    lrqE_error(ewhat, "unlink", path, lrqEwhat, lrqEwhy);
}
