#include "lrqElib.h" /* must be first */
#include <stdio.h>
#include <fcntl.h>
#include <ctype.h>

#define STREQ(boy,girl)	(*(boy) == *(girl) && !strcmp(boy,girl))

char *progname = "etest";
extern char *strchr();

struct s_list {
    char *name;
    int m;
} slist[] = {
    { "O_RDONLY",	O_RDONLY },
    { "O_WRONLY",	O_WRONLY },
    { "O_RDWR",	O_RDWR },
    { "O_NDELAY",	O_NDELAY },
    { "O_APPEND",	O_APPEND },
    { "O_SYNC",	O_SYNC },
    { "O_CREAT",	O_CREAT },
    { "O_TRUNC",	O_TRUNC },
    { "O_EXCL",	O_EXCL },
    { (char *) 0, 0 }
};

main(argc, argv)
    int argc;
    char *argv[];
{
    int i;
    char *file;
    struct s_list *sp;
    char *ap;
    int mode, cmode;
    int destroy = 0;

    if (argc < 3) {
	fprintf(stderr, "Usage: test file whatfor [creatmode]\n");
	exit(1);
    }

    file = argv[1];
    mode = 0;

    if (isdigit(argv[2][0])) {
	mode = atoi(argv[2]);
    } else for (ap = argv[2]; *ap; ap++) {
	char *pipe = strchr(ap, '|');

	if (pipe) {
	    *pipe = '\0';
	}

	for (sp = slist; sp && sp->name; sp++) {
	    char *rm = "O_UNLINK";
	    if (STREQ(sp->name, ap)) {
		mode |= sp->m;
		break;
	    } else if (STREQ(ap, rm)) {
		destroy++;
		sp = slist; /* inhibit error message */
		break;
	    }
	}

	if (!sp || !sp->name) {
	    fprintf(stderr, "Unknown file mode \"%s\"\n", ap);
	    exit(1);
	}

	if (pipe) {
	    *pipe = '|';
	    ap = pipe;
	} else {
	    break;
	}
    }
    cmode = (argc > 3) ? atoi(argv[3]) : 0;

    i = open(file, mode, cmode);

    printf("Opened %s, mode %d\n", file, mode);

    close(i);

    if (destroy) {
	unlink(file);
    }

    exit(0);
}
