.\" t
.\" use sqtbl % | troff -man
.
.TH lq l "1.14, May 1996" "\(co Liam Quin 1989, 1993, 1996" "lq-text programs"
.
.\" $Id: lq.man,v 1.1 96/05/30 21:55:35 lee Exp $
.
.SH NAME
lq \- front end to lq-text database
.SH SYNOPSIS
.B lq
[
.B \-sgml
] [
options
]
.SH DESCRIPTION
.I lq
is a shell-script that can be used as an interactive front end to a
database made with
.IR lqaddfile .
.
.PP
When run,
.I lq
first prints a brief message, and then prompts for phrases to be entered,
one per line.
If you press return twice in a row, entering a blank line,
.I lq
passes the phrases to
.I lqrank
and
.IR lqkwic ,
to produce an index of the matches.
By default, the index lists every document in the database which
contains all of the phrases given.
For each such document, a single line's worth of text shows the
immediate context of the match.
.PP
Instead of typing a phrase at the prompt, it is possible to type
a command.
Commands all start with a colon (:).
Note that since all
.I lq-text
programs treat all punctuation as equivalent, if you actually need to
find a word starting with a colon, you can use some other punctuation
character such as a parenthsis or full\%stop (period).
.PP
The current list of commands can be found by typing
.B :help
at the
.I lq
prompt.
Further descriptions of individual commands are also available,
for example
.B :set
gives a list of the possible options that can be set, and
.B ":set rank"
explains the possible arguments to the
.B ":set rank"
command, and also gives the current value.
.
.SH "OPTIONS"
.TP
.B -sgml
enables use of the entity replacement file in the database
directory, and also sets the
.I lq
option to represent sequences of
.SM SGML
tags as a single character,
which is \[de]\~by default.
.PP
Remaining arguments are interpreted as if each such argument were 
a single line of input to
.IR lq .
.
.SH ENVIRONMENT
All the environment variables described in
.IR lq-text "\^(l)"
are understood; in particular,
.SM LQTEXTDIR
can contain the name of a directory containing the database to be used.
.
.SH BUGS
Interrupts sometimes make the program quit.
.br
No way to specify complex queries.
.br
Should probably do asynchronous processing of queries for extra speed.
.
.SH "SEE ALSO"
.IR lq-text "\^(l),"
.IR lqaddfile "\^(l),"
.IR lqkwic "\^(l),"
.IR lqphrase "\^(l),"
.IR lqrank "\^(l),"
.IR lqshow "\^(l),"
.IR lqword "\^(l)."
.IR lqwordlist "\^(l),"
.
.SH AUTHOR
Liam R. E. Quin, 1989, 1993, 1996
