.\" t
.\" use sqtbl % | troff -man
.
.TH lqkwic l 1996 "\(co Liam Quin 1989, 1993, 1996" "lq-text programs"
.
.SH NAME
lqkwic \- keyword-in-context presentation of lq-text text retrieval results
.
.SH SYNOPSIS
.de oB
. RB [ \\$1 ]
..
.de oI
. RB [ \\$1
. IR "\\$2" ]
..
.B lqkwic
.oI \-A After
.oI \-E file
.if o \{.
.oI \-C c
.oB \-c
.oB \-E file
. \}
.oI \-f file
.oI \-g w
.oB \-i
.oB \-L
.oI \-l lw
.oB \-M
.oI \-O filerange
.oI \-o matchrange
.oI \-r rw
.oI \-S FileFormat
.oI \-s MatchFormat
.SH DESCRIPTION
.PP
Search results obtained with
.I lqrank
or
.I lqphrase
(or, most efficiently,
.I lqword
(with the
.I -l
option),
can be used by
.I lqkwic
to produce a variety of output formats.
By default, the output of
.I lqkwic
shows the text immediately before and after each match, with an optional
extra gap just before the matched text, whose width is specified by the
argument to the
.B -g
option.
.PP
The default behaviour if no arguments are given is to read standard input.
.SH "STANDARD OPTIONS"
All of the standard options described in
.IR lq-text "\^(1)"
are honoured, as well as those described below.
.TP
.oI \-A After
The given
.I After
string is used as a Glue Format, as described under
.SM GLUE
below, after the last match in each document.
The format should not contain any references to the last match's data,
however, is this is not currently implemented.
.if 0 \{.
.TP
.oI \-E file
In
.SM SGML
mode, read the given file, which must contain two fields, separated
by whitespace, on each line: the first field is the name of an entity,
and the second is a string, in double quotes, with which to replace that
entity's name in
.I lqkwic
output.
.oI \-C c
.oB \-c
.\}
.TP
.oI \-f file
The given
.I file
should contain matches in the format produced by
.IR lqphrase ;
the matches will be processed one at a time using the Glue Format
Expressions given by the \-A, \-S and \-s options or their respective
defaults.
The filename \- can be used to refer to standard input.
.TP
.oI \-g w
Specify the default gap (gutter width) for columns.  This is represented by
the Glue Variable ${Gap}, which evaluates to a sequence of
.I gap
spaces.
.TP
.oB \-i
Causes
.I lqkwic
to replace the
.SM SGML
characters < > and & with entities &lt;, &gt; and &amp; respectively.
.TP
.oB \-L
Causes
.I lqkwic
to list all known Glue Variables.
.TP
.oI \-l lw
Specifies the minimum number of characters that
.I lqkwic
should allocate to the left of each match for stored data.
The default is usally adequate, but if you are using the
.B \-i
or (undocumented)
.B \-C
option, you will need to specify extra storage with
.B \-l
and
.BR \-r.
.TP
.oB \-M
Enable Backwards Compatibility Match Mode, in which the
.I lq-text
match format did not include a leading number indicating the number
of words in the match.
.TP
.oI \-O filerange
Process only documents that fall within the given range.
See
.IR lq-text "\^(1)"
for the syntax of ranges.
The first document is number one.
.TP
.oI \-o matchrange
Process only matches that fall within the given range.
The first match is number one.
See
.IR lq-text "\^(1)"
for the syntax of ranges.
.TP
.oI \-r rw
See
.B \-l
for a description of this.
.TP
.oI \-S FileFormat
The specified Glue Expression (see below) will be evaluated and
printed whenever a match is encountered from a document other than
that of the preceding document, and also for the very first match encountered.
If a range of documents was given with the
.B \-O
option, the
.I FileFormat
will only be used for documents falling within that range.
.TP
.oI \-s MatchFormat
The specified Glue Expression (see below) will be evaluated and
printed for each match enountered.
If a range of matches was given with the
.B \-o
option, the
.I MatchFormat
will only be used for matches falling within that range.
.SH "GLUE EXPRESSIONS"
A
.I "Glue Expression"
is a string containing embedded variable references.
A variable is referenced using the syntax ${\fI\&name\fP}, where
.I name
is taken from the list below.
You should run
.I lqkwic
.B \-x
.B \-v
.B \-L
to see the actual list supported on your platform.
The following list is typical:
@@
.SH "GLUE FORMATS"
Currently, any variable or gluestring (using ${variable} or $[gluestring])
may end in a format specification of the form /\fI\&minwidth\ maxwidth\fP.
If necessary, the object to be formatted is first converted to a string.
If the resulting string is narrower than
.IR minwidth ,
it is padded with spaces as necesssary.
If
.I minwidth
is an asterisk (*), it is treated as if it were the actual length
of the string.
If
.I minwidth
is followed by
.BR l ,
.B c 
or
.BR r ,
the string is placed at the left, in the centre, or at the right of a field
that is
.I minwidth
spaces wide, by adding spaces at the other end as necessary.
After that is done, if
.I maxwidth
is specified,
the resulting string is truncated on the side specified by a following
.BR l ,
.B c 
or
.BR r ;
for example, consider the Glue Expression ${DocName/10r\ 30l}.
Here, the variable
.I DocName
will be inserted.
If
.I DocName
is shorter than ten characters, it wil be made exactly 10 charaacters
long by adding spaces on the left, so that it's right-justified in its
10-character fieldwidth.
Then, if it is longer than 30 characters, all but the rightmost 30 will
be removed (starting with the leftmost).
This treatment is particularly useful for long pathnames where the
rightmost part is usually most significant.
.PP
You can concatenate several variables and format them using a Glue String:
.br
.RS
$[${DocPath} and\ ${DatabaseTitle}/* 78r]
.RE
.
Note that Glue Strings cannot nest in the current implementation.
.
.SH "GLUE VARIABLES"
All variable names are converted to lower case before being used,
so you can type them how you want.
Exception: termcap variables with names
starting with
.I t.
are retained as they were given.
The variables may be roughly divided into categories as follows.
.
.TS
box;
lb s
r | l.
[1] ASCII Character names
T{
BS, CR FF, LF, NL,
BackSpace, ESC, Escape,
FormFeed, LineFeed, NewLine,
Return, CarriageReturn
T}	T{
each replaced by the corresponding
.SM ASCII
character.
T}
Quote	Replaced by a double quote (")

.T&
lb  s
r | l.
[2] Global Database Information
LQTEXTDIR, DatabaseDirectory	the full path to the database
DatabaseTitle	the title of the database
DatabaseURL	a URL that gives Word Wide Web access to the database
DatabaseAdminEMail	email address of the dtabase administrator
DatabaseDataEMail	email address of whoever owns/publishes the data

.T&
lb  s
r | l.
[3] Files and Documents
DocName	the name of the current document, as stored in the database
FileName	the apsolute path corresponding to ${DocName}
DocTitle	the title of the document
FID	the File Identifier Number of the document
FileNumber	T{
starts at one and increases for each new document in the output
T}
LastDocName	T{
the last value of DocName that was different from the current value;
the format
given with -S (${MatchFileFormat}) is used each time DocName changes.
T}

.T&
lb  s
r | l.
[4] Match-Specific Variables
BlockInFile, WordInBlock	these determine the location of the match
NumberOfWordsInPhrase	the length in words of the phrase matched
TextBefore	the text in the document immediately before the match
MatchedText	the document text that exactly matches the phrase
TextAfter	the text in the document immediately after the match
MatchNumber	starts at 1 and increases for each match; the format
given with -s (${MatchFormat}) is used to print each match.
MatchWithinFile	like MatchNumber but reset for each new document
StartByte	the byte offset in the file at which the match begins
EndByte	the byte offset in the file at which the match ends
Matchlength	length in bytes of ${MatchedText} (EndByte - StartByte)

.T&
lb  s
r | l.
[5] Terminal-Specific Variables
t.so, t.se	start and end stand-out mode (usually reverse video)
t.xx	T{
xx is looked up in the termcap/terminfo database for your
terminal; xx can be any string.  If this doesn't do what you want,
using `tput xx` is often better if you have it
.br
(/usr/5bin/tput xx for SunOS 4.x).
T}

.T&
lb  s
r | l.
[6] Output-Formatting Variables
Gap	a string of spaces, corresponding to the \-g command-line argument.
LeftPad	T{
enough spaces to pad ${TextBefore} to the width given in
the \-l\ \fI\&n\fP\& command-line argument
T}
RightPad	T{
enough spaces to pad ${TextAfter} to the width given in
the \-n\ \fI\&n\fP\& command-line argument
T}
MatchFileFormat	the argument given to \-S, or the default value
Matchformat	the argument given to \-s, or the default value
.TE

.SH "Reversing Values"
You can use a leading ! sign to reverse the contents of a
variable, e.g. ${!TextBefore} will turn
.I Simon
into
.IR nomiS .
.PP
If you use !!, the string will be reversed, and then each individual
word will be reveresed, and if you use !!! the whole thing will again
be reversed; !!!! will reverse the words in that, giving the original.
.br
Example:
.br
.RS
.nf
.ft CW
given    $[barefoot boy in blue],  you will get:
with !     eulb ni yob tooferab
with !!    blue in boy barefoot
with !!!   tooferab yob ni eulb
with !!!!  barefoot boy in blue
.ft
.fi
.RE
This is used by lqsort, for example, to sort matched words together.
.
.SH "Glue Backslash Escapes"
Use \e\e, \e$, \en, \er, \ef, \eb or \ee to insert the corresponding
character (\ee is Escape, ASCII ESC); $$ also inserts a single $ sign.
.
.SH "Glue Filters"
You can apply any of a number of filters to a variable by appending
a colon and the name of the filter, for example ${DocTitle:ToLowerCase}.
The default set of filters compiled in to
.I lqkwic
is as follows:
.TP
:DeletePunctuation
which removes all punctuation characters, as determined by
.I ispunct
(see
.I ctype "(3)"
for more information),
from the string to which it is applied;
.TP
:SplitAtPunctuation
which turns punctation characters into spaces;
this is useful in conjunction with word reversal, described above.
.TP
:DeleteAfterDot
This removes everything after the first dot (.) character in the string.
.TP
:ToLowerCase
This converts to lower case, using
the C
.IR tolower
library function.
.TP
:ToUpperCase
This converts to upper case, using
the C
.IR toupper
library function.
.TP
:RemoveSpaces
This removes spaces in the string to which it is applied.
.PP
Note that you can use more than one filter at a time:
.br
.RS
If ${FileName} is /usr/dict/words,
.br
${!!FileName:SplitAtPunctuation:ToLowerCase}
.br
will give
.br
words dict usr
.RE
.br
This turns out to be especially useful if the output from
.I lqkwic
is to be used as input to
.IR sort "(1)."
.SH EXAMPLE
.br
.RS
lqphrase "Jesus Wept" | lqkwic -f -
.RE
.br
.SH ENVIRONMENT
.TP
.SM COLS
is used to determine the screen width in order to set the default line length.
.PP
Other environment variables are as described in
.IR lq-text "\^(1)."
.SH BUGS
.SH AUTHOR
Liam R. Quin, 1989, 1993
