.\" t
.\" use sqtbl % | troff -man
.
.
.\" $Id: lqrank.man,v 1.1 96/05/31 01:19:22 lee Exp $
.
.TH lqrank l 1993 "\(co Liam Quin 1989, 1993" "lq-text"
.
.SH NAME
lqrank \- sort results of lq-text full-text retrieval queries
.SH SYNOPSIS
.
.de oB
. RB [ \\$1 ]
..
.de oI
. RB [ \\$1
. IR "\\$2" ]
..
.B lqrank
.oB \-ouvVx
.oI \-c file
.oI \-d dir
.oI \-t n
.oI \-f file
.oI \-r rank
.oI \-p phrase
[
.I phrase
] .\|.\|.
.SH DESCRIPTION
Use
.I lqrank
to combine files containing
.I lq-text
text retrieval matches, or to generate new sets of matches.
By default,
.I lqrank
takes phrases from the command-line, and produces internal sets of
match results for each phrase.
Alternatively, sets of match results generated by
.I lqword
.BR \-l ,
or by
.IR lqphrase ,
can be specified with the
.B \-f
option to
.IR lqrank .
.PP
.I lqrank
then combines 
these matches in the way specified by the argument to the
.B \-r
option.
In any event, the matches are sorted first by the documents in which they
occur, so that all of the matches in a given document are grouped together
in the output.
Matches within a document are sorted by location within that document,
so that passing the result to
.I lqshow
(for example)
won't jump about within a documnt.
.
.SH OPTIONS
.TP
.BI \-f \^file
The
.I file
is taken to contain the results of an earlier run of
.I lqrank ,
.I lqword ,
or
.IR lqphrase .
.TP
.B \-o
Prints only the first match from each document.
.TP
.BI \-p \^phrase
The given
.I phrase
is matched against the database to produce an internal set of results.
You can combine and intermix
.B \-f
and
.B \-p
options at pleasure.
.TP
.BI \-r \^mode
Changes the ranking algorithm used.
The default value for
.I mode
is
.IR all .
.IP
A
.I mode
of
.I none
or
.I or
produces output containing all of the matches from the imput, sorted
as described above.
.IP
A
.I mode
of
.I all
or
.I and
produces output containing only matches that occur in documents that
contain at least one instance of every phrase given to
.IR lqrank .
.IP
A
.I mode
of
.I most
or
.I quorum
produces output containing all of the matches from the imput, sorted
so that documents containing all of the phrases come before those containing
fewer of the phrases.
The number of matches of any given phrase within a document is not taken
into consideration, only the number of distinct phrases matched.
.IP
In the future,
other rank types may include statistical ranking by phrase, by
phrase weighted by rankings of individual words, and by document taking
file length into account.
These may also be used to support relevance feedback.
.LP
Remaining options are taken to be files containing matches, as for the
.B \f
option described above.
.SH EXAMPLES
.RS
lqrank -p "to be or not to be" "alas poor" | lqkwic
.RE
This shows all ocurrences of either of the two given phrases,
but only in documnents containing both of them.
.PP
.RS
lqword \-l John > john.lqm
.br
lqphrase \-mr Richard > richard.lqm
.br
lqrank -o \-f john.lqm \-f richard.lqm |
.br
  lqkwic -S '' -s '${FileName}${NewLine}'
.RE
This prints the names of files containing both `John' and `Richard'.
See
.IR lqkwic "\^(1)"
for an explanation of the difference between ${Document\%Name}
and ${File\%Name}.
.PP
Note that it is important to quote arguments that contain spaces or $-signs,
so that the shell doesn't try and get excited about them.
.SH ENVIRONMENT
.SH BUGS
.SH "SEE ALSO"
.SH AUTHOR
Liam R. Quin, 1989, 1993, 1996
