#include "lrqElib.h"
#include "lrqEdefs.h"
#include <fcntl.h>


#ifdef lrqEclse
# undef lrqEclose
#endif
#undef close

int
lrqEclose(descriptor)
    int descriptor;
{
    int result;
    int savsyserrno;
    char *reason;
    int ewhat; /* what kind of error -- fatal, etc. */

    /* Reset error string; */
    errno = 0;

    if ((result = close(descriptor)) >= 0) {
	return result;
    }
    /* we have an error */
    ewhat = lrqE_severity; /* default */

    /* Save the original error message */
    savsyserrno = errno;

    switch (errno) {
    case EBADF:
	reason = "\n\tbecause it doesn't represent an open file";
	ewhat = lrqE_EPROG;
	break;
    case EINTR:
	reason = "\n\tbecause a signal arrived.";
	break;
    case ENOLINK:
	reason = "\n\tbecasue the file is on a remote machine that's down";
	break;
    default:
	reason = sys_errlist[errno];
	break;
    case 0:
	reason = "\n\t... for an unknown reason";
    }

    lrqE_error(ewhat, "can't close descriptor %d (%s)", descriptor, reason);
    return -1;
}
