#include <stdio.h>
#include "lrqEdefs.h"
#include "lrqElib.h"

/* These must be defined by the user, I'm afraid */
extern char *progname;
/* If you don't set this, well, it seems to be NULL */
char *cmdname;

int lrqE_severity = lrqE_ENORMAL; /* errors are not fatal */

/* You would normally change this with lrqE_seterror() */

#undef lrqE_errprint

/*VARARGS2*/
void
lrqE_errprint(howbad, fmt, a1, a2, a3, a4, a5, a6)
    int howbad;
    char *fmt;
{
    int i;
    int fatal = 1; /* exit if set */

    if (lrqE_severity == 0 && howbad < lrqE_EURGENT && !(howbad&lrqE_EFATAL)) {
	return;
    }

    if (cmdname != (char *) 0 && *cmdname != '\0') {
	fprintf(stderr, "%s: ", cmdname);
    }

    if (progname != (char *) 0 && *progname != '\0') {
	fprintf(stderr, "%s: ", progname);
    } else if (cmdname == (char *) 0) {
	fprintf(stderr, "error: [neither progname nor cmdname defined...]\n\t");
    }

    if (howbad & lrqE_EWARN) {
	fprintf(stderr, "warning: ");
	fatal = 0;
    } else if (howbad & lrqE_EPROG) {
	fprintf(stderr, "program error: ");
    }

    fprintf(stderr, fmt, a1, a2, a3, a4, a5, a6);
    fputc('\n', stderr);
    if (fatal) {
	exit(2);
    }
}

void (* lrqE_eprfunc)() = lrqE_errprint;

#undef lrqE_seterror

lrqE__vfp
lrqE_seterror(f, severity)
    void (* f)();
{
    if ((lrqE_severity = severity) < 0) {
	lrqE_errprint("lrqE_seterror: severity (%d) should be >= 0; program error", severity);
    }
    lrqE_eprfunc = (f) ? f : lrqE_errprint;
}

void
lrqE_noerror()
{
    errno = 0;
}

