#include <stdio.h>
#include "lrqEdefs.h"
#include "lrqElib.h"

/* The Printing of Error Messages
 *
 * There are three main parts to an error message:
 *
 * (1) The command and program name
 * These come from cmdname and progname, respectively.
 *
 * (2) The "what" bit -- e.g.
 * open: couldn't create "martin" in exclusive mode for writing
 * these are generated by the stub routines in the stdio, libc etc.
 * directories (e.g. open.c) and left in lrqE_whatbuf.
 *
 * (3) The "why" bit -- e.g.
 * the file already exists
 * also generated by the stub routines, or by the check routines in this
 * directory, and left in lrqE_whybuf.
 *
 * There are two main routines.  There's a thing like sprintf for writing
 * into the buffers, checking lengths etc., that's based on the
 * Tahoe printf -- it's called lrqE_eprintf.
 * Then there's lrqE_errprint, called with the final strings --
 *    lrqE_errprint(what, why);
 *
 * The user can override errprint() and provide a replacement.
 *
 */

/* You may want to reduce the length of these a little,
 * especially if you have a small address space.
 */

#ifndef lrqEWHATLEN
# define lrqEWHATLEN 500
#endif

#ifndef lrqEWHYLEN
# define lrqEWHYLEN 500
#endif

char lrqEwhat[lrqEWHATLEN];
char lrqEwhy[lrqEWHYLEN];

int lrqE_severity = lrqE_ENORMAL; /* errors are not fatal */

#undef lrqE_errprint

lrqE__setwhat(fmt, a1, a2, a3, a4, a5)
    char *fmt;
{
    (void) sprintf(lrqEwhat, a1, a2, a3, a4);
}

lrqE__setwhy(fmt, a1, a2, a3, a4, a5)
    char *fmt;
{
    (void) sprintf(lrqEwhy, a1, a2, a3, a4);
}

lrqEerror(etype, caller, path, what, why)
    int etype;
    char *caller; /* the function/syscall in which the error ocurred */
    char *path; /* 0 if inappropriate */
    char *what; /* what we tried to do */
    char *why; /* why it failed */
{
    if (lrqE_severity == 0 && howbad < lrqE_EURGENT && !(howbad&lrqE_EFATAL)) {
	return;
    }

    if (cmdname != (char *) 0 && *cmdname != '\0') {
	fprintf(stderr, "%s: ", cmdname);
    }

    if (progname != (char *) 0 && *progname != '\0') {
	fprintf(stderr, "%s: ", progname);
    } else if (cmdname == (char *) 0) {
	fprintf(stderr, "error: [neither progname nor cmdname defined...]\n\t");
    }

    if (howbad & lrqE_EWARN) {
	fprintf(stderr, "warning: ");
	fatal = 0;
    } else if (howbad & lrqE_EPROG) {
	fprintf(stderr, "program error: ");
    }

    fprintf(stderr, what, path);
    fprintf(stderr, " --\n\t%s\n", why);

    if (fatal) {
	exit(2);
    }
}

/*VARARGS2*/
void
lrqE_errprint(howbad, fmt, a1, a2, a3, a4, a5, a6)
    int howbad;
    char *fmt;
{
    int i;
    int fatal = 1; /* exit if set */

    if (lrqE_severity == 0 && howbad < lrqE_EURGENT && !(howbad&lrqE_EFATAL)) {
	return;
    }

    if (cmdname != (char *) 0 && *cmdname != '\0') {
	fprintf(stderr, "%s: ", cmdname);
    }

    if (progname != (char *) 0 && *progname != '\0') {
	fprintf(stderr, "%s: ", progname);
    } else if (cmdname == (char *) 0) {
	fprintf(stderr, "error: [neither progname nor cmdname defined...]\n\t");
    }

    if (howbad & lrqE_EWARN) {
	fprintf(stderr, "warning: ");
	fatal = 0;
    } else if (howbad & lrqE_EPROG) {
	fprintf(stderr, "program error: ");
    }

    fprintf(stderr, fmt, a1, a2, a3, a4, a5, a6);
    fputc('\n', stderr);
    if (fatal) {
	exit(2);
    }
}

void (* lrqE_eprfunc)() = lrqE_errprint;

#undef lrqE_seterror

lrqE__vfp
lrqE_seterror(f, severity)
    void (* f)();
{
    if ((lrqE_severity = severity) < 0) {
	lrqE_errprint("lrqE_seterror: severity (%d) should be >= 0; program error", severity);
    }
    lrqE_eprfunc = (f) ? f : lrqE_errprint;
}

void
lrqE_noerror()
{
    errno = 0;
}

