#include "globals.h" /* defines and declarations for database filenames */

#include <errno.h>
#include "error.h"

#include <stdio.h>
#include <sys/types.h>
#include <malloc.h>
#include <ctype.h>
#include "emalloc.h"
#include "fileinfo.h"
#include "lqutil.h"
#include "liblqtext.h"

static char *Revision = "$Id: lqmv.c,v 1.2 96/08/14 17:03:07 lee Exp $";
extern int errno;

/* The position of the \n in the 26-char string returned by ctime(3): */
#define DATENEWLINE 24

char *progname;

/** System calls and library functions used in this file: **/

/** Unix System calls: **/
extern void exit();
/** System Library Functions: **/

/** external lqtext functions: **/
/** Functions defined within this file: **/

int
main(argc, argv)
    int argc;
    char *argv[];
{
    extern int optind, getopt();
    /** extern char *optarg; (unused at the moment) **/
    int ch;
    int ErrorFlag = 0;

    progname = argv[0];

    /* All programs take Zz:Vv */
    while ((ch = getopt(argc, argv, "VvAax")) != EOF) {
	switch (ch) {
	case 'V':
	    fprintf(stderr, "%s version %s\n", progname, Revision);
	    break;
	case 'x':
	    ErrorFlag = (-1);
	    break;
	case '?':
	    ErrorFlag = 1;
	    break;
	}
    }

    /* Normally put call to lrqError here to give a helpful message,
     * but not yet ready to ship the error handling package, sorry
     */
    if (ErrorFlag) {
	fprintf(stderr, "%s: usage: %s [options]\n",progname,progname);
	exit((ErrorFlag > 0) ? 1 : 0);
    }

    /* Rename files */
    {
	char *oldName[2041];
	char *newName[2041];

	oldName[0] = '\0';
	while (fgets(oldName, sizeof(oldName) - 1, stdin) != (char *) NULL) {
	    if (oldName[0]) {
		register char *p, *q;

		for (p = oldName, q = newName; *p; p++,q++) {
		    if (islower(*p)) {
			*q = toupper(*p);
		    } else if (*p == '\n') {
			*q = *p = '\0';
			break;
		    } else {
			*q = *p;
		    }
		}
		if (rename(oldName, newName) < 0) {
		    Error(E_WARN|E_SYS,
			"couldn't rename \"%s\" to \"%s\"",
			oldName,
			newName
		    );
		}
	    }
	}
    }

    exit(0);
    /*NOTREACHED*/
    return 1; /* for lint and gcc... */
}
