.\" t
.\" use sqtbl % | troff -man
.
.TH lqword l 1996 "\(co Liam Quin 1989, 1993, 1996" "lq-text programs"
.
.SH NAME
lqword \- print words in an lq-text database vocabulary
.SH SYNOPSIS
.B lqword
[
.B -A
] [
.B \-a
] [
.B \-C
] [
.B \-l
] [
.B \-N
] [
.B \-s
] [
.B \-W
]
[
.I word
] .\|.\|.
.SH DESCRIPTION
.PP
Use
.I lqword
to search the stored voabulary of an
.I lq-text
database.
In other words, you can ask
.I lqword
to show you some or all of the words thta the database knows about,
together with how many times they occur, or even where they occur.
.SH "OPTIONS"
.PP
The options described here are in addition to those given in
.IR lq-text "\^(1)."
.TP
.B -A
Show all occurrences of all words.
For a large database, this could take a long time.
Running
.I lqword
\-A is a convenient way to test that a database has not been corrupted;
.br
.RS
lqword -A > /dev/null
.RE
should produce no output and exit with status zero.
.TP
.B \-a
show information about every word in the database, but do not print
information for every occurrence of every word.
.PP
This option is useful in conjunction with
.IR grep (1),
although the
.I lqwordlist
program may be more convenient.
.TP
.B \-C
When used with \-a or \-A, print a count of the number of occurrences of
each word, together with the maximum word identifier (WID) in the database.
This is similar to
.br
.RS
lqwordlist -u -g .
.RE
but somewhat faster.
.br
.TP
.B \-l
List format: print output in the same match format tht is read by
.IR lqrank ,
.IR lqkwic ,
and other
.I lq-text
programs.
.TP
.B \-N
When used with \-A, suppresses filenames.
Not available in the current release.
.TP
.B \-s
Silent mode; do not print anything.
In this mode,
.I lqword
exits with a zero exit status if there were no words given on the
command line that were not in the database.
.TP
.B \-W
WID mode: treat arguments as numeric WID values rather than as words.
.SH BUGS
.SH AUTHOR
Liam R. Quin, 1989, 1993, 1996
