.\" t
.\" use sqtbl % | troff -man
.
. \" $Id: lqwordlist.man,v 1.1 96/05/31 02:03:31 lee Exp $
.
.TH lqwordlist l 1996 "\(co Liam Quin 1989, 1993, 1996" "lq-text programs"
.
.SH NAME
lqwordlist \- search the lq-text vocabulary
.SH SYNOPSIS
.
.de oB
. RB [ \\$1 ]
..
.de oI
. RB [ \\$1
. IR "\\$2" ]
..
.B lqwordlist
.oI \-e suffix
.oI \-p prefix
.oI \-g pattern
.oB -nsu
.oI \-f file
[
.I word
] .\|.\|.
.SH DESCRIPTION
Use
.I lqwordlist
to find words that are in the index to an
.I lqtext
database.
In effect,
.I lqwordlist
is rather like using
.IR grep \^(1)
against a file containing every distinct word that is in the database,
one per line.
In addition,
.I lqwordlist
can add the number of occurrences of each word.
.\" and also the number of files in which the word occurs.
.SH OPTIONS
.TP
.B \-e 
Treat arguments as word endings; for example,
.br
.RS
.I lqwordlist
\-e ingly
.RE
.br
will print all words that are stored in the
.I lq-text
vocabulary ending with
.IR ingly .
.TP
.B \-g
Treat arguments as
.IR egrep -style
patterns:
.br
.RS
.I lqwordlist
\-g '^b[ao]y'
.RE
.br
will find all words beginning with either
.I bay
or
.IR boy .
.TP
.B \-n
Print the number of times each word occurs in the database.
Note that an occurrence of zero is possible if
.I sortwids
has not been run, and files have been removed from the database with
.IR lqunindex .
.TP
.B \-p
Treat arguments as word prefixes; for example,
.br
.RS
.I lqwordlist
\-e unh
.RE
.br
will print all words that are stored in the
.I lq-text
vocabulary beginning with
.IR unh .
.TP
.B \-s
Sort the output.  This is the default behaviour.
.TP
.B \-u
Do not sort the output; this is the opposite of \-s, and is generally
much faster.
After you have run
.IR sortwids ,
the output from
.I lqwordlist
will always be sorted, although in that case using the
.B \-u
option will still be significantly faster.
.TP
.B \-W
Give the
.SM WID
(word identifier) of each word printed.
.TP
.B \-w word
Treat
.I word
as a word even if it begins with a hyphen and would thus normally be
an option.
.SH BUGS
.SH AUTHOR
Liam R. E. Quin, 1989, 1993, 1996
