/* filter.h -- Copyright 1989, 1996 Liam R. E. Quin.  All Rights Reserved.
 * This code is NOT in the public domain.
 * See the file COPYRIGHT for full details.
 */

/* filter.h -- define filter table for lq-text Liam Quin's text retrieval
 * program.
 * There should be an external table, but there isn't yet...
 *
 * $Id: filter.h,v 1.18 1996/06/12 02:45:54 lee Exp $
 *
 */

#ifndef LQ_FILTER_H
# define LQ_FILTER_H 1

#ifndef FILE
# include <stdio.h>
#endif

#define FTYPE_NEWS  1
#define FTYPE_MAIL  2
#define FTYPE_DEFAULT 3
#define FTYPE_SGML 4
#define FTYPE_TROFF 5


/* the actual filters */
LIBRARY int LQF_SGML_Copy(
# ifdef HAVE_PROTO
    t_LQTEXT_Database *db,
    FILE *InputFile,
    char *Name,
    FILE *OutputFile
# endif
);

LIBRARY int LQF_NetNews_Copy(
# ifdef HAVE_PROTO
    t_LQTEXT_Database *db,
    FILE *InputFile,
    char *Name,
    FILE *OutputFile
# endif
);

LIBRARY int LQF_RFC822_Copy(
# ifdef HAVE_PROTO
    t_LQTEXT_Database *db,
    FILE *InputFile,
    char *Name,
    FILE *OutputFile
# endif
);

LIBRARY int LQF_Troff_Copy(
# ifdef HAVE_PROTO
    t_LQTEXT_Database *db,
    FILE *InputFile,
    char *Name,
    FILE *OutputFile
# endif
);


/* The Type field in each array entry is so that I can do some very simple
 * checking...
 */
typedef struct s_FilterTable {
    int Type;
    char *Name; /* no more than 10 chars if possible, please */
    int (* copyFile)(); /* input filter */
    int (* findMatchEnds)(); /* unused for now */
    int (* findFile)(); /* unused for now */
    int (* closeFile)(); /* how to close the darned stream */
} t_FilterTable;

LIBRARY t_FilterTable *LQTpFilterTable;

#define LQT_MaxFilterType(db) FTYPE_TROFF

#endif /* LQ_FILTER_H */
